import java.util.Random;
import java.util.TimerTask;


public class MehanicniModel extends TimerTask {
	private static double g = -100.0 ;
	private double radius; // polmer žoge
	private double x, y; // pozicija
	private double vx, vy; // hitrost žoge
	private long t0; // cas, ob katerem je veljavno stane (x,y,vx,vy)
	private long t_risanje; // cas, ko smo se nazadnje narisali
	private BoingPanel panel;
	
	public MehanicniModel(BoingPanel panel) {
		super();
		this.panel = panel;
		this.radius = 30;
		Random rnd = new Random();
		// Naključno izberemo pozicijo in hitrost
		this.x = 2 * radius + rnd.nextDouble() * (panel.getWidth() - 4 * radius);
		this.y = 2 * radius + rnd.nextDouble() * (panel.getHeight() - 4 * radius);
		double v = 400.0;
		double phi = rnd.nextDouble() * Math.PI;
		this.vx = v * Math.cos(phi);
		this.vy = v * Math.sin(phi);	
		this.t0 = System.currentTimeMillis();
		this.t_risanje = 0;
	}

	public double getRadius() {
		return radius;
	}

	public double getX() {
		return x;
	}

	public double getY() {
		return y;
	}

		public double getEnergy() {
		double m = 1.0; // masa
		double v2 = this.vx * this.vx + this.vy * this.vy;
		return m * Math.abs(MehanicniModel.g) * this.y + 0.5 * m * v2;
	}
	
	@Override
	public void run() {
		// Ta metoda se kliče periodično
		long t1 = System.currentTimeMillis(); // trenutni cas;
		double dt = (double)(t1 - this.t0)/1000.0; // cas, ki je pretekel od zadnjega klica
		this.x += this.vx * dt;
		this.y += this.vy * dt + 0.5 * g * dt * dt;
		// odboji
		if (this.x < this.radius) {
			// leva stena
			this.vx = -this.vx;
			this.x = this.radius;
		}
		else if (this.x + this.radius > this.panel.getWidth()) {
			// desna stena
			this.vx = -this.vx;
			this.x = this.panel.getWidth() - this.radius;
		}
		if (this.y < this.radius) {
			// spodnja stena
			this.vy = -this.vy;
			this.y = this.radius;
		}
		else if (this.y + this.radius > this.panel.getHeight()) {
			// zgornja stena
			this.vy = -this.vy;
			this.y = this.panel.getHeight() - this.radius;
		}
		this.vy += MehanicniModel.g * dt;
		this.t0 = t1;
		// Ce je preteklo vsaj 50 ms, se narisi
		if (t1 - this.t_risanje > 1) {
			this.t_risanje = t1;
			this.panel.repaint();
		}
	}

}
