import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Timer;

import javax.swing.JLabel;
import javax.swing.JPanel;


@SuppressWarnings("serial")
public class BoingPanel extends JPanel {
	private int width;
	private int height;
	private MehanicniModel model; // fizikalna simulacija
	private JLabel energija; // napis, kamor se piše energijo
	private Timer animator; // timer, ki skrbi za animacijo

	public BoingPanel(int width, int height, JLabel energija) {
		super();
		this.width = width;
		this.height = height;
		this.energija = energija;
		this.model = new MehanicniModel(this);
	}
	
	public int getWidth() {
		return width;
	}

	public int getHeight() {
		return height;
	}

	@Override
	public Dimension getPreferredSize() {
		return new Dimension(width, height);
	}

	@Override
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
		int h = getHeight();
		int d = (int)(2 * this.model.getRadius());
		int x = (int)(this.model.getX() - this.model.getRadius());
		int y = h - (int)(this.model.getY() + this.model.getRadius());
		g.setColor(Color.RED);
		g.fillOval(x, y, d, d);
		// Tu malce goljfuamo:
		this.energija.setText(Double.toString(this.model.getEnergy()));
	}

	public void animiraj() {
		// Timer je objekt, ki periodicno klice metodo run() v objektu task
		this.animator = new Timer(true);
		// Aktiviramo Timer
		this.animator.scheduleAtFixedRate(this.model, 5, 5);
	}


}
